-------------------------------------------------------------------------------
--   
--  File:			rolloutCreator.ms
--  Description:	Helper struct and routines for loading/saving xml data into Max

-- History:
-- 2.0 .NET Port conversion Chris P. Johnson
-- Complete overhaul of the script replacing activeX controls with .NET classes.
-- 
-- 1.3 Original Version Ravi Karra 
-- Ravi.karra@discreet.com
--
-- Note:			DO NOT LOCALIZE
-------------------------------------------------------------------------------


struct sxmlIO
(
	xmlCtrlDocName, 
	m_xmlDoc,
	xmlCtrlDoc,
	world,
	--subAnims2xml_fn,
	--xml2subAnims_fn,
	exec_time,
	create_time,
	animatedOnly,
	is_ik_ctrl,
	tmc_class,
	class_of      = "classOf",
	sclass_of     = "superClassOf",		
	wireParams    = #(#numWires, #isMaster, #isSlave, #isTwoWay, #slaveAnimation),
	no_key_frames = false,
	------------------------------------------------------------------------------------
	-- general purpose functions
	------------------------------------------------------------------------------------
	function exec str = 
	(
		local st = timeStamp()
		local val = execute str
		exec_time += timeStamp() - st
		val
	),
	function getAttribute xmlNode attr = 
	(
		local attr_node = xmlNode.attributes.getNamedItem (attr as string)
		if attr_node != undefined then attr_node.value else ""
	),
	function isAnimated subAnim =
 	(
		local bAnimated = false
		try 
		( 
			bAnimated = subAnim.isAnimated
			if bAnimated then return true
			for i = 1 to (custAttributes.count subAnim) do
			(
				local ca = custAttributes.get subAnim i
				for s = 1 to ca.numSubs do
				(
					if ca[s].isAnimated then return true				
				)
			)
			local baseObj = subAnim.baseobject
			local subCount = baseObj.numSubs
			for i = 1 to subCount do
			(
				if baseObj[i].isAnimated then return true
			)
		)
		catch 
		( 
			try 
			(
				if subAnim.controller != undefined do 
				(
					bAnimated = subAnim.controller.isAnimated
				)
			) catch()
		)
		bAnimated
	),
	function string2value str xmlElem:unsupplied = 
	(
		if xmlElem == unsupplied then
			exec str
		else
		(
			local cls = (getAttribute xmlElem class_of) as name
			case cls of
			(
				#undefinedClass: undefined
				#booleanClass:   str == "true"
				#float:		  str as float
				#integer:		  str as float
				#point3: 		  ( local a = filterString str "[,]"; [a[1] as float , a[2] as float, a[3] as float])
				#string:		  str
				#name:		  str
				default: 		  exec str
			)
		)
	),
	-- tempObjs is a temporary array of objects filled by this function and ***MUST*** be freed by caller
	function create xmlElem \
					hide:true \
					tempObjs:(#()) \
					tmElem:undefined = 
	(	
		local st = timeStamp()
		local cls = getAttribute xmlElem class_of
		local attributeName = getAttribute xmlElem #name
		local ins
--		try
--		(
--			if cls == "DummyChannel" or cls == "On_Off" do return undefined
--			
--			if cls == "Circle" then ins = Circle hidden:true
--			else if cls == "Point" then ins = Point hidden:true
--			else if cls == "line" then ins = Line hidden:true
--			else 
			
			case cls of
			(
				"DummyChannel": ( return undefined ) 
				"On_Off":       ( return undefined )
				"Circle":
				(
					ins = Circle hidden:true
				)
				"Point":
				(
					ins = Point hidden:true	
				)
				"line":
				(
					ins = Line hidden:true
				)
				"SplineShape":
				(
					ins = circle isHidden:hide
					convertTo ins SplineShape
				)
				"Editable_mesh":
				(
					ins = box isHidden:hide
					convertTo ins Editable_mesh
				)
				"Editable_Patch":
				(
					ins = box isHidden:hide
					convertTo ins Editable_Patch
				)
				"Editable_Poly":
				(
					ins = box isHidden:hide
					convertTo ins Editable_Poly	
				)
				"NURBSSurf":
				(
					ins = box isHidden:hide
					convertTo ins NURBSSurf
				)
				"BoneGeometry":
				(
					ins = boneSys.createBone [0,0,0] [10,10,10] z_axis
					ins.isHidden = hide
				)
				"IK_Chain_Object":
				(
					local boneC = boneSys.createBone [0,0,0] [10,10,10] z_axis
					local boneP = boneSys.createBone [10,10,10] [20,20,20] z_axis
					boneC.parent = boneP
					ins = ikSys.ikchain boneP boneC "IKLimb"
					ins.isHidden = hide
					append tempObjs boneC; append tempObjs boneP
				)
				"Sunlight_Daylight_Slave_Controller":
				(
				)				
				default:
				(
--					ins = createInstance (string2value cls xmlElem:xmlElem)
					try
					(
						ins = execute (cls + "()")
					) 
					catch 
					( 
						format "Not Creatable: %\n" cls; 
						return undefined
					)
				)
			)
			if attributeName != undefined and attributeName != "" do ins.name = attributeName
			if tmc_class == "IKControl" then
			(
				local boneP = boneSys.createBone [10,10,10] [20,20,20] z_axis					
				ins.parent = boneP
				local ikC = ikSys.ikchain boneP ins "IKLimb"					
				append tempObjs boneP; append tempObjs ikC
			)
			create_time += timeStamp() - st
			ins
--		)
		/*catch 
		(
			--format "  Cannot successfully create % of type %\n" name cls
			undefined
		)*/
	),	
	-- creates a new element in the addons element category
	function newAddOn parentElem tagName =
	(
		local addonElem = parentElem.selectSingleNode "addons"
		if addonElem == undefined then
		(
			addonElem = m_xmlDoc.createElement "addons"
			parentElem.appendChild addonElem
		)
		local newElem = m_xmlDoc.createElement tagName
		addonElem.appendChild newElem
		newElem
	),
	function getAddon parentElem tagName =
	(
		parentElem.selectSingleNode ("addons/" + tagName)
	),
	function CollectItemOfArray pObject = 
	(
		--Returns a maxscript array of items.
		--Pre: Only .NET collections that have a .ItemOf member should
		--be passed to this function.
		local result = #()
		local count = pObject.count - 1
		for i = 0 to count do
		(
			append result pObject.itemOf[i]
		)
		result
	),
	------------------------------------------------------------------------------------
	-- max 2 xml functions
	------------------------------------------------------------------------------------	
	function array2xml arr arrElem =
	(
		--Array to XML
		local str
		if isValidNode arr[1] then
		(
			arrElem.setAttribute "type" "object"
			str = "#("
			for i=1 to (arr.count-1) do str += "$" + arr[i].name + ","
			if arr.count > 0 then str += "$" + arr[arr.count].name
			str += ")"
		)
		else
		(
			if arr.count > 20 then
			(
				str = "#("
				for i=1 to (arr.count-1) do str += arr[i] as string + ","
				if arr.count > 0 then str += arr[arr.count] as string
				str += ")"				
			)
			else
			(
				
				str = (arr as string)
			)
		)
		arrElem.innerText = str
	),
	-- TODO: support param wiring 
	function wire2xml ctrl ctrlElem = 
	(
		wireParams
	),
	function cas2xml fromAnim animElem =
	(
		--Custom Attributes to XML
		local casElem =  m_xmlDoc.createElement "customAttributes"
		animElem.appendChild casElem
		local custAttributesCount = (custAttributes.count fromAnim)
		for c = 1 to custAttributesCount do
		(
			local def = custAttributes.getDef fromAnim c
			local fca = custAttributes.get fromAnim c
			
			local caElem = m_xmlDoc.createElement "customAttribute"
			local defElem = m_xmlDoc.createElement "definition"
			casElem.appendChild caElem
			caElem.appendChild defElem
			
			-- add the definition source			
			defElem.innerText = (custAttributes.getDefSource def)
			
			-- now output the property values
			SubAnims2xml fca caElem
		)
	),
	function Ctrl2xml ctrl animElem =
	(
		--Controler to XML
		--Create an element for the controller
		local ctrlElem =  m_xmlDoc.createElement "controller"
		ctrlElem.setAttribute class_of ((classOf ctrl) as string)
		animElem.appendChild ctrlElem
		
		gXmlIO.SubAnims2xml ctrl ctrlElem
		if not no_key_frames and ctrl.keys.count > 0 then 
		(
			--TODO: implement this
/*			
			-- read keyproperties from "controller.xml"
			xmlCtrlDoc.load xmlCtrlDocName -- hack! to reset the iterator
			local kpElem = xmlCtrlDoc.selectSingleNode ("//controller[@classOf='" + (classOf ctrl) as string + "']/key")
			
			if kpElem != undefined then
			( 
				local keyMap = kpElem.attributes
				local keysElem = m_xmlDoc.createElement "keys"
				ctrlElem.appendChild keysElem
				for ky in ctrl.keys do
				(
					for k=0 to (keyMap.length-1) do 
					( 
						local pp = (getProperty ky keyMap[k].name)						
						keyMap[k].text = if (classof pp) ==  Name then ("#" + pp as string) else (pp as string)
					) 
					keysElem.appendChild (kpElem.cloneNode true)
				)
			)
--			else format "node controller info for :%\n" (classof ctrl)
*/
		)
		else
		(
			local valueElem =  newAddOn ctrlElem "value"
			valueElem.setAttribute class_of ((classOf ctrl.value) as string)
			valueElem.innerText = ctrl.value as string
		)
		
	),
	function subAnims2xml anim animElem =
	(
		--SubAnimatable property to XML
		local propertylist
		try
		(
			propertylist = getPropNames anim --getSubAnimNames anim
		) catch ( return() )
			
		local propsElem = m_xmlDoc.createElement "properties"
		animElem.appendChild propsElem
		
		local subAnimatablePropertyCount = propertylist.count
		for i = 1 to subAnimatablePropertyCount do
		(
			local propvalue
			try ( propvalue = getProperty anim propertylist[i] ) catch ( continue )
			
			if propertylist[i] == undefined do continue
			
			local saElem = m_xmlDoc.createElement (propertylist[i] as string)
			propsElem.appendChild saElem
			saElem.setAttribute class_of ((classOf propvalue) as string)
			local ctrl = getPropertyController anim propertylist[i]
			if ctrl == undefined then
			(
				local claass = classof propvalue
				local superclaas = superClassOf propvalue
				if claass == Array or claass == ArrayParameter then
					array2xml propvalue saElem				
				else if superclaas == Value or superclaas == Number then
					saElem.innertext = propvalue as string -- set the property value
				else
				(
					saElem.setAttribute sclass_of (superclaas as string)
					subAnims2xml propvalue saElem -- incase of a reference target
				)
			)
			else
			(
				Ctrl2xml ctrl saElem
			)
		)
	),
	function obj2xml obj parentElem             \
					 postCallback:undefined \
					 recurse:true           \
					 chkTransform:true      \
					 chkBaseObject:true     \
					 chkModifiers:true      \
					 chkCustAttrib:true =
	(
		--Object to XML
		local nodeElem = m_xmlDoc.createElement "object"
		parentElem.appendChild nodeElem
		nodeElem.setAttribute "name"                 (obj.name)
		nodeElem.setAttribute class_of             ((classOf obj.baseobject) as string)
		nodeElem.setAttribute sclass_of        ((superclassOf obj.baseobject) as string)
		nodeElem.setAttribute "isAnimated"           ((isAnimated obj) as string)
		nodeElem.setAttribute "id"                   (obj.inode.handle as string)

		-- <transform>
			if chkTransform then
			(
				local tmElem = m_xmlDoc.createElement "transform"
				nodeElem.appendChild tmElem
				local tmc = obj.controller
				tmElem.setAttribute class_of ((classOf tmc) as string)			
				subAnims2xml tmc tmElem
			)
		-- </transform>
	
		-- <baseObject>	support for animated base object sub-anims based on sub-anim name
			if chkBaseObject do
			(
				local objElem = m_xmlDoc.createElement "baseObject"
				nodeElem.appendChild objElem
				objElem.setAttribute class_of ((classOf obj.baseobject) as string)
				subAnims2xml obj.baseObject objElem
			)			
			-- <customAttributes>
				if chkCustAttrib then cas2xml obj.baseObject objElem				
			-- </customAttributes>
		-- </baseObject>
		
		-- <modifiers> support for animated modifier sub-anims based on modifier name
			if chkModifiers do
			(
				local modsElem = m_xmlDoc.createElement "modifiers"
				nodeElem.appendChild modsElem
				for mod in obj.modifiers do
				(
					-- <modifier>			
						local modElem = m_xmlDoc.createElement "modifier"
						local sc = superclassOf mod
						modsElem.appendChild modElem
						modElem.setAttribute "name" mod.name
						modElem.setAttribute class_of ((classOf mod) as string)						
						modElem.setAttribute sclass_of (sc as string)
						if sc == SpacewarpModifier then 
							modElem.setAttribute "bindTo" (refs.dependson mod)[1].name
						subAnims2xml mod modElem
						-- <customAttributes>
							if chkCustAttrib then cas2xml mod modElem
						-- </customAttributes>
					-- </modifier>
					
				)
			)
		if postCallback != undefined then postCallback obj -- notify back the calling function
		gc()
		-- <children>
		if recurse and obj.children.count > 0 then
		(
			local chldElem = m_xmlDoc.createElement "children"
				nodeElem.appendChild chldElem
			for c in obj.children do 
				obj2xml c chldElem  postCallback:postCallback recurse:recurse	
		)
		-- </children>
	),
	
	------------------------------------------------------------------------------------
	-- xml 2 max functions
	------------------------------------------------------------------------------------
	function xml2cas animElem toAnim = 
	(
		--Convert XML to custom attributes
		local caElems =  animElem.selectNodes "customAttributes/customAttribute"
		if caElems == undefined then return()
		
		local customAttCount = (caElems.length-1)
		for c = 0 to customAttCount do
		(
			local caElem = caElems[c]
			local def = (caElem.selectSingleNode "definition").innerText
			
			-- add the definition
			custAttributes.add toAnim (exec def)
			local tca = custAttributes.get toAnim (custAttributes.count toAnim)			
						
			-- now read the property values
			gXmlIO.xml2subAnims caElem tca
		)
	),
	function xml2ctrl animElem ctrl =
	(
		if ctrl == undefined then return()
		local keysElem = animElem.selectSingleNode "keys"
		if not no_key_frames and keysElem != undefined then
		(
			local ckeys = CollectItemOfArray keysElem.childNodes
			local swi_ang = (is_ik_ctrl and animElem.parentNode.Name == "Swivel_Angle")
			local exec_string = ""
			local obj = ctrl.keys
			local keysCount = (ckeys.length-1)
			for k = 0 to keysCount do
			(
				local kyp = ckeys[k].attributes				
				local time = kyp[0].innerText as float
				local ky = addNewKey ctrl time
				local ks = ";___obj[" + (k+1) as string + "]."
				local keyPropCount = (kyp.length-1)
				for i = 1 to keyPropCount do --for each key property
				(
					exec_string += ks + kyp[i].name + "=" + kyp[i].text					
					-- hack to fix swivel angle wackiness
					if swi_ang and kyp[i].name == "value" then exec_string += "*pi/180"
				)
			)
			exec exec_string
		)
		gXmlIO.xml2subAnims animElem ctrl
	),
	function xml2subAnims animElem anim =
	(
		if anim == undefined then return()
		if animatedOnly and ((getAttribute animElem "isAnimated") == "false") do return()
		
		-- .childNodes retuans a System.XML.XMLNodeList class object
		local hxmlNodeList = (animElem.selectSingleNode "properties").childNodes
		local subAnimElems = CollectItemOfArray hxmlNodeList
		local count = subAnimElems.count - 1 --.NET arrays are zero based
		for i = 0 to count do
		(
			local subAnimElem = subAnimElems[i]
			local ctrlElem = subAnimElem.selectSingleNode "controller"
			local cls = getAttribute subAnimElem class_of
	
			if ctrlElem == undefined then
			(
--				format "  % - %\n" subAnimElem.name subAnimElem.innerText
				if not animatedOnly then
				(
					local sc = getAttribute subAnimElem sclass_of
					local prop = getProperty anim subAnimElem.name
					if cls == "Array" or cls == "ArrayParameter" then
					(
						try 
						(
							local arr = exec subAnimElem.innerText
							format "%\n" arr
							try ( setProperty anim subAnimElem.name arr )
							catch( for i=1 to arr.count do prop[i] = arr[i] )
						)
						catch 
						( 
							/*format "  Cannot set the array property %.%\n" (getAttribute animElem class_of) subAnimElem.name;*/
							continue 
						)
					)					
					else if sc == "" then -- a value type
					(
						local val = string2Value subAnimElem.innerText xmlElem:subAnimElem
						try 
						( 
							if val != undefined then setProperty anim subAnimElem.name val 
						)
						catch 
						( 
							format "  Cannot set the property % of % to %\n" subAnimElem.name (getAttribute animElem class_of) val;  
							continue 
						)
					)
					else
					(
						-- incase of a reference target like the shadowMap of a light						
						if sc != "MAXObject" and cls != (classof prop) then
						(
							prop = create subAnimElem
							try ( setProperty anim subAnimElem.name prop )
							catch ( format "  Cannot set the property % of % to %\n" subAnimElem.name (getAttribute animElem class_of) val; continue )
						)
						xml2subAnims subAnimElem prop
					)
				)
			)			
			else			
			(
				local ctrl = getPropertyController anim subAnimElem.name
				local prop = subAnimElem.name
				if ((classof ctrl) as string) != cls then 
				(
					ctrl = create ctrlElem
					if ctrl == undefined then continue
					try (
						if i > 0 and subAnimElems[count-1].name == "available" then
							prop = #available -- in case of a lookat controller
						if (setPropertyController anim prop ctrl) == undefined then				
							throw ""
					) catch ( format "  Cannot set %.%.controller = %\n" (getAttribute animElem class_of) prop (classof ctrl);  continue )
				)
--				format "  % - % - %\n" subAnimElem.name subAnimElem.xml cls
				xml2ctrl ctrlElem ctrl
				
				-- get the value of the controller
				local vElem = getAddon ctrlElem "value"
				if vElem != undefined then setProperty ctrl "value" (string2value vElem.innerText xmlElem:vElem)	
			)
		)
	),	
	function xml2obj nodeElem obj:undefined hide:true chkTransform:true chkBaseObject:true chkModifiers:true chkCustAttrib:true =
	(
		local tempObjs = #()
		local tmElem = nodeElem.selectSingleNode "transform"
		local tmc_class = getAttribute tmElem class_of

		if obj == undefined then
		(
			obj = create nodeElem hide:hide tempObjs:tempObjs tmElem:tmElem
			if obj == undefined then return undefined		
			obj.name = getAttribute nodeElem #name
		)		
		
		-- <transform>
			if chkTransform and tmElem != undefined do
			(
				local tmc = obj.controller
				if ((classof tmc) as string) != tmc_class do
				(
					if (gEnableDebug == true ) do
					(	
						format "xml2obj->chkTransform: % -- % %\n" tmc obj tmc_class
					)
					tmc = create tmElem
					if tmc != undefined do
					(
						obj.controller = tmc
					)
				)
				is_ik_ctrl = (classof tmc == IKChainControl)
				tmc_class = ""
				if (tmc != undefined ) do
				(
					gXmlIO.xml2subAnims tmElem tmc
				)
			)
		-- </transform>
	
		-- <baseObject> support for animated base object sub-anims based on sub-anim name
			if chkBaseObject do
			(
				local objElem = nodeElem.selectSingleNode "baseObject"
				gXmlIO.xml2subAnims objElem obj.baseObject
				-- <customAttributes>
					if chkCustAttrib do xml2cas objElem obj.baseObject
				-- </customAttributes>
			)			
		-- </baseObject>
		
		-- <modifiers> Support for animated modifier sub-anims based on modifier name
			if chkModifiers do
			(
				local xmlNodeListB = (nodeElem.selectSingleNode "modifiers").childNodes
				local modsElem = CollectItemOfArray xmlNodeListB
				if modsElem != undefined then
				(
					local count = (modsElem.count - 1)
					for m = 0 to count do
					(
						-- <modifier>			
							local modElem = modsElem[m]
							if (getAttribute modElem sclass_of) == "SpacewarpModifier" then
							(
								local bindTo = getNodeByName (getAttribute modElem "bindTo")
								if bindTo != undefined do
								(
									bindSpaceWarp obj bindTo
								)
							)
							else
							(
								local mod = create modElem
								if mod != undefined do
								(
									addModifier obj mod
									xml2subAnims modElem mod
									-- <customAttributes>
										if chkCustAttrib then xml2cas modElem mod
									-- </customAttributes>
								)
							)							
						-- </modifier>						
					)
				)
			)
		-- </modifiers>
		
		-- free any temporary objects created by create function
		delete tempObjs
		gc()
		obj
	),
	------------------------------------------------------------------------------------
	-- Init functions
	------------------------------------------------------------------------------------
	-- call this before you start any I/O operations 
	function init force:false = 
	(
		exec_time = create_time = 0
		node_id = 0		
	
		dotnet.LoadAssembly "system.xml.dll" returnPassFail:true
		
		m_xmlDoc = dotNetObject "System.Xml.XmlDocument" 
		
		local cpi = m_xmlDoc.createProcessingInstruction ("xml") ("version=\"1.0\" encoding = \"Windows-1252\"")
		m_xmlDoc.AppendChild cpi
		
		local sceneElem = m_xmlDoc.createElement "scene"
		m_xmlDoc.appendChild sceneElem
		local worldElem = m_xmlDoc.createElement "world"
		sceneElem.appendChild worldElem
		
		--m_xmlDoc.save "C:/Projects/scene_xml_output.xml"
		animatedOnly = false
	),
	
	-- loads an xml document into memory
	function load xmlDocName =
	(
		m_xmlDoc.load xmlDocName
	),
	
	-- save the in-memory xml document to file 
	function save xmlDocName =
	(
		m_xmlDoc.save xmlDocName
	)	
)
-- declare a global instance 
gXmlIO = sxmlIO xmlCtrlDocName:((getDir #maxRoot) + "stdplugs\\stdscripts\\baseLib\\controllers.xml")


/*
( -- save example
	gXmlIO.init()	
	local worldElemsList = gxmlIO.m_xmlDoc.GetElementsByTagName "world"
	local worldElem = worldElemsList.item[0]
	
	for ob in rootNode.children do gXmlIO.obj2xml ob worldElem
	gXmlIO.save "C:/Projects/scene_xml_output.xml"
)

( -- load example
	resetMaxFile #noPrompt
	local st = timeStamp()
	gXmlIO.init()
	gXmlIO.load "D:/MaxScript/MergeAnim/birdSource.xml"
	local objs = gXmlIO.m_xmlDoc.selectNodes "//object"
 	for i=0 to (objs.length-1) do
		gXmlIO.xml2obj objs[i]
	format "Execute Time:%\%\n" ((100*gXmlIO.exec_time)/(timeStamp()-st))
)

*/
